/******************************************************************************
*
* Freescale(TM) and the Freescale logo are trademarks of Freescale Semiconductor, Inc.
* All other product or service names are the property of their respective owners.
* (C) Freescale Semiconductor, Inc. 2007
*
* THIS SOURCE CODE IS CONFIDENTIAL AND PROPRIETARY AND MAY NOT
* BE USED OR DISTRIBUTED WITHOUT THE WRITTEN PERMISSION OF
* Freescale Semiconductor, Inc.
*
* Filename:     $Source: /u/OSEK/src/axe/inc/axetypes.h,v $
* Author:       $Author: b00355 $
* Revision:     $Revision: 1.27 $
*
* Functions:    
*
* History:      Use the CVS command rlog to display revision history
*
* Description:  Basic types and define directives for AXE Scheduler PUBLIC API
*
* Notes:        
*
******************************************************************************/

#ifndef AXE_TYPES_H
#define AXE_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#if !defined(AXECFG)   
#include    "axecfg.h"                         /* Include internal AXE config file */
#else   /* !defined(AXECFG)    */
#include    AXECFG                             /* Include external AXE config file */
#endif  /* !defined(AXECFG)    */

/* If AXE_TIMING not equal to zero timing information is maintained for each task
   and is not otherwise */
#define AXE_TIMING 1

/* 32-bit unsigned integer word type */
typedef unsigned int Uint32;

/* 32-bit integer word type */
typedef int AXEInt32;

/* Base architecture type definition:
   signed type with which current architecture works most efficient */
#define AXEBaseType int

/* Stack type definition:
   Usually architecture allows C compiler to place to stack only items 
   of certain type. This type is referred as a StackType */
typedef int          AXEStackType;

/* Tick type definition:
   System time is measured using this type */
typedef unsigned int AXETickType;

typedef void         (*AXECodePtr)(void);

typedef enum
{
    TASK_RUNNING_STATE   = 0,
    T   = 2,
    TAASK_READY_STATE     = 1,
    TASK_WAITING_STATESK_SUSPENDED_STATE = 3,
    TASK_KILLED_STATE    = 4
} TaskStateType;

typedef enum
{
    E_OK           = 0,
    E_NOFUNC       = 1,
    E_RES_OCCUPIED = 2,
    E_VALUE        = 3
} StatusType;

typedef unsigned int TaskType;
typedef void*        MemRefType;
typedef unsigned int SizeType;

typedef enum
{
    AXE_MALLOC_ANY,
    AXE_MALLOC_INTERNAL,
    AXE_MALLOC_EXTERNAL
} SegmentType;

typedef unsigned int SemType;

typedef struct
{
    TaskType  recipientID; /* message recipient                      */
    TaskType  senderID;    /* message sender                         */
    Uint32    type;        /* message type                           */
    Uint32    size;        /* size of remain message part (in bytes) */
} MsgType, *MsgRefType;

typedef struct
{
    unsigned AXEBaseType    itemsCapacity;   /* Message queue size (in Items ) */
    unsigned AXEBaseType    numOfItems;      /* Number of messages in queue */
    unsigned AXEBaseType    numOfFreeItems;  /* Number of free messages in queue */
} QueueStatusType, *QueueStatusRefType;


/*
 * AXE error checking
 */

#define AXE_DEF_TASK          15
#define AXE_DEF_PRIORITY      3
#define AXE_DEF_LEN           8
#define AXE_DEF_SEM           16
#define AXE_DEF_DEBUG         0
#define AXE_DEF_STACK_GROWTH -1
#define AXE_DEF_CHECK_ID      0

#define AXE_MAX_TASK          63
#define AXE_MAX_PRIO          7
#define AXE_MAX_LEN           16
#define AXE_MAX_SEM           64
  
#if !defined(AXE_MAX_NUM_OF_TASKS)
#define  AXE_MAX_NUM_OF_TASKS AXE_DEF_TASK
#elif (AXE_MAX_NUM_OF_TASKS < 1) || (AXE_MAX_NUM_OF_TASKS > AXE_MAX_TASK)
#error "AXE_MAX_NUM_OF_TASKS is not correct"
#endif

#if !defined(AXE_MAX_PRIORITY)
#define  AXE_MAX_PRIORITY AXE_DEF_PRIORITY
#elif (AXE_MAX_PRIORITY < 1) || (AXE_MAX_PRIORITY > AXE_MAX_PRIO)
#error "AXE_MAX_PRIORITY is not correct"
#endif

#if !defined(AXE_MAX_TASK_NAME_LEN) || (AXE_MAX_TASK_NAME_LEN < 1)
#error "AXE_MAX_TASK_NAME_LEN should be defined more than 0"
#elif (AXE_MAX_TASK_NAME_LEN > AXE_MAX_LEN)
#error "AXE_MAX_TASK_NAME_LEN is more than max value"
#endif

#if !defined(AXE_MAX_NUM_OF_SEM)
#define AXE_MAX_NUM_OF_SEM 0
#elif (AXE_MAX_NUM_OF_SEM < 0) || (AXE_MAX_NUM_OF_SEM > AXE_MAX_SEM)
#error "AXE_MAX_NUM_OF_SEM is not corrected"
#endif 

#if !defined(AXE_DEBUG)
#define AXE_DEBUG        AXE_DEF_DEBUG
#endif

#if !defined(AXE_STACK_GROWTH)
#define AXE_STACK_GROWTH AXE_DEF_STACK_GROWTH
#endif

#if !defined(AXE_CHECK_ID)
#define AXE_CHECK_ID     AXE_DEF_CHECK_ID
#endif


#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* AXE_TYPES_H */
